/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef _AVE_MACHINE_H_
#define _AVE_MACHINE_H_

#include "avev3_linux.h"

#if !defined(CONFIG_PROC_MN2WS0270) && !defined(CONFIG_PROC_MN2WS0251)
#error "Error: Can build AVEther driver for MN2WS0270 only."
#endif

#define AVEV3_ES_SLD8





#define AVEV3_DDRMEM_SHIFT   (0x00000000)

#undef  AVEV3_MACHINE_BIGENDIAN 

#define LAN_CSBASE  (0x57000000)
#define _AVEV3_BASE (LAN_CSBASE)
#define _AVEV3_IRQ  (98)

#define AVEV3_USE_PHY_RTL8201               

#define AVEV3_REG_READ(value, addr)   value = avev3_reg_read(addr)
#define AVEV3_REG_WRITE(value, addr)  avev3_reg_write(value, addr)

#define AVEV3_SOCREG_REVISION    (0x5f800000)
#define AVEV3_READ_SOCREG(addr)  avev3_read_socreg(addr)


#define AVEV3_PHY_ETHER 0x01    
#define AVEV3_PHY_CLINK 0x02    

#define AVEV3_PHY_ID        AVEV3_PHY_ETHER

#define AVEV3_PHY_MCRL  0x01
#define AVEV3_PHY_SMSC  0x1f
#define AVEV3_PHY_REALTEK   0x03
#define AVEV3_PHY_ATHRS (0x04)

#define MII_SMSC_ISFR   (29)    
#define MII_SMSC_IMR    (30)    
#define SMSC_ANCOMP _BIT6   
#define SMSC_LINKDOWN   _BIT4   

#define MII_MCRL_ICS    (0x1B)  
#define MCRL_CTRL_DOWN  _BIT10  
#define MCRL_CTRL_UP    _BIT8   
#define MCRL_STS_DOWN   _BIT2   
#define MCRL_STS_UP _BIT0   
#define MII_MCRL_CTRL2  (0x1F)  
#define MCRL_PAIRSWAP_D _BIT13  
#define MCRL_POWERSAVE  _BIT10  
#define MCRL_ADV_PAUSE  _BIT10  

#define MII_ATHRS_ICR    (0x12)  
#define MII_ATHRS_ISR    (0x13)  
#define ATHRS_INT_LKUP  _BIT10  
#define ATHRS_INT_LKDN  _BIT11  

#ifdef AVEV3_USE_PHY_RTL8201
#define AVEV3_ENABLE_POL_LINKCHK              
#endif

#define RTL8201FL_P0R13_MACR    (13)     
#define RTL8201FL_P0R14_MAADR   (14)     
#define RTL8201FL_P0R31_PSR     (31)     
#define RTL8201FL_P1R17_PARAM   (17)     
#define RTL8201FL_P1R18_PARAM   (18)     
#define RTL8201FL_P1R21_PARAM   (21)     
#define RTL8201FL_P7R24_SSCR    (24)     
#define RTL8201FL_MMDD7_EEEAR   (0x3c)   
#define RTL8201FL_REG_PAGE0     (0)      
#define RTL8201FL_REG_PAGE1     (1)      
#define RTL8201FL_REG_PAGE7     (7)      
#define RTL8201FL_MMD_ADDR_DEV7 (0x0007) 
#define RTL8201FL_MMD_DATA_DEV7 (0x4007) 
#define RTL8201FL_SSC_DISABLE   _BIT0    
#define RTL8201FL_EEE_ENABLE    _BIT1    
#define RTL8201FL_P1R18_DEFAULT (0x9088)
#define RTL8201FL_P1R18_MODIFY  (0x90A8)


extern long avev3_get_macaddr(char *macaddr);
extern void avev3_peaks_set_irq_lvl(int irq);
extern void avev3_peaks_enable_irq(int irq);
extern void avev3_peaks_disable_irq(int irq);
extern void avev3_peaks_clear_irq(int irq);
extern void avev3_endian_change(void *data);
extern void initialize_target(void);
extern int avev3_phy_init(struct net_device *dev);
extern int avev3_phy_intr_chkstate_negate(struct net_device *dev);
extern void avev3_purge_cache(unsigned long start, unsigned long size, int flag);
extern int avev3_panic(int panic_param);
extern void mn_set_lateack_irq_type(int irq);

#endif  
